<?php
// Include the connection file
include 'conn.php';

// Get the raw POST data
$jsonTestData = file_get_contents('php://input');

// Decode the JSON data into a PHP associative array
$testOrderTests = json_decode($jsonTestData, true);

// Check if data is received properly
if ($testOrderTests) {
    // Loop through each test record in the array
    foreach ($testOrderTests as $testData) {
        // Use INSERT ... ON DUPLICATE KEY UPDATE to handle insert/update in one query
        $query = "INSERT INTO " . $table_initial . "tbtests (
                    vtype, labno, testcode, testhead, testsubhead, testname, RESULT, 
                    pRESULT, REFVALUE, units, torder, ISNORMAL, ISCRITICAL
                  ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                  )
                  ON DUPLICATE KEY UPDATE
                    testhead = VALUES(testhead),
                    testsubhead = VALUES(testsubhead),
                    testname = VALUES(testname),
                    RESULT = VALUES(RESULT),
                    pRESULT = VALUES(pRESULT),
                    REFVALUE = VALUES(REFVALUE),
                    units = VALUES(units),
                    torder = VALUES(torder),
                    ISNORMAL = VALUES(ISNORMAL),
                    ISCRITICAL = VALUES(ISCRITICAL)";

        if ($stmt = $conn->prepare($query)) {
            // Bind parameters
            $stmt->bind_param(
                "siisssssssiis", 
                $testData['vtype'], 
                $testData['labno'], 
                $testData['testcode'], 
                $testData['testhead'], 
                $testData['testsubhead'], 
                $testData['testname'], 
                $testData['RESULT'], 
                $testData['pRESULT'], 
                $testData['REFVALUE'], 
                $testData['units'], 
                $testData['torder'], 
                $testData['ISNORMAL'], 
                $testData['ISCRITICAL']
            );

            // Execute the query
            if (!$stmt->execute()) {
                // Log the error if execution fails
                error_log("Failed to process test data: " . $stmt->error);
            }

            // Close the statement
            $stmt->close();
        } else {
            // Log the error if the query preparation fails
            error_log("Failed to prepare query: " . $conn->error);
        }
    }

    // Send a success message back to the client
    echo json_encode(["status" => "success", "message" => "Test data processed successfully"]);
} else {
    // Send an error message if no valid JSON data is received
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
}

// Close the database connection
$conn->close();
?>