<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['usercode'])) {
    header("Location: login.php");
    exit();
}

require_once 'conn.php';



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['logout'])) {
    session_destroy();
    header("Location: login.php");
    exit();
}
date_default_timezone_set('Asia/Karachi');

$dateFilter = isset($_POST['dateFilter']) ? $_POST['dateFilter'] : date('Y-m-d');
$signedFilter = isset($_POST['signedFilter']) ? $_POST['signedFilter'] : 'all';

$startDate = $dateFilter . ' 00:00:00';
$endDate = $dateFilter . ' 23:59:59';

$sql = "SELECT * FROM " . $table_initial . "tbpatients WHERE tdate BETWEEN ? AND ?";
if ($signedFilter != 'all') {
    $sql .= " AND issigned = ?";
}
$stmt = $conn->prepare($sql);
if ($signedFilter == 'all') {
    $stmt->bind_param("ss", $startDate, $endDate);
} else {
    $stmt->bind_param("ssi", $startDate, $endDate, $signedFilter);
}

$stmt->execute();
$result = $stmt->get_result();

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patients Data</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
        }
        .table thead th {
            vertical-align: middle;
        }
        .buttons {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center my-4">Patients Data</h2>
        
        <div class="buttons text-right">
            <form method="POST" class="d-inline">
                <button type="submit" name="logout" class="btn btn-danger">Logout</button>
            </form>
        </div>

        <form method="POST" class="mb-4">
            <div class="form-row align-items-center">
                <div class="col-auto">
                    <label for="dateFilter" class="col-form-label">Date</label>
                    <input type="date" class="form-control mb-2" id="dateFilter" name="dateFilter" value="<?php echo $dateFilter; ?>">
                </div>
                <div class="col-auto">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="signedFilter" id="all" value="all" <?php echo ($signedFilter == 'all') ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="all">All</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="signedFilter" id="signed" value="1" <?php echo ($signedFilter == '1') ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="signed">Approved</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="signedFilter" id="notSigned" value="0" <?php echo ($signedFilter == '0') ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="notSigned">Not Approved</label>
                    </div>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-primary mb-2">Filter</button>
                </div>
            </div>
        </form>

        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Lab No</th>
                    <th>Visit Type</th>
                    <th>Date</th>
                    <th>Patient Name</th>
                    <th>Consultant</th>
                    <th>Approved</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>{$row['ID']}</td>";
                        echo "<td>{$row['labno']}</td>";
                        echo "<td>{$row['vtype']}</td>";
                        echo "<td>{$row['tdate']}</td>";
                        echo "<td>{$row['PNAME']}</td>";
                        echo "<td>{$row['CONSULTANT']}</td>";
                        echo "<td>" . ($row['issigned'] ? 'Yes' : 'No') . "</td>";
                        echo "<td><a href='view_patient.php?id={$row['labno']}' class='btn btn-info'>View</a></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='8' class='text-center'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>
