<?php
// Include the connection file
include 'conn.php';

// Get the raw POST data
$jsonTestData = file_get_contents('php://input');

// Decode the JSON data into a PHP associative array
$testOrderTests = json_decode($jsonTestData, true);

// Check if data is received properly
if ($testOrderTests) {
    // Loop through each test record in the array
    foreach ($testOrderTests as $testData) {
        // Check if a record already exists with the same `vtype`, `labno`, and `testcode`
        $checkQuery = "SELECT COUNT(*) FROM " . $table_initial . "tbtests WHERE vtype=? AND labno=? AND testcode=?";
        if ($stmt = $conn->prepare($checkQuery)) {
            // Bind parameters
            $stmt->bind_param("sii", $testData['vtype'], $testData['labno'], $testData['testcode']);
            $stmt->execute();
            $stmt->bind_result($count);
            $stmt->fetch();
            $stmt->close();
            
            // If the record exists, perform an update; otherwise, insert a new record
            if ($count > 0) {
                // Perform an UPDATE operation
                $updateQuery = "UPDATE " . $table_initial . "tbtests SET testhead=?, testsubhead=?, testname=?, RESULT=?, pRESULT=?, REFVALUE=?, 
                                units=?, torder=?, ISNORMAL=?, ISCRITICAL=? WHERE vtype=? AND labno=? AND testcode=?";
                if ($stmt = $conn->prepare($updateQuery)) {
                    $stmt->bind_param(
                        "sssssssiissii", 
                        $testData['testhead'], 
                        $testData['testsubhead'], 
                        $testData['testname'], 
                        $testData['RESULT'], 
                        $testData['pRESULT'], 
                        $testData['REFVALUE'], 
                        $testData['units'], 
                        $testData['torder'], 
                        $testData['ISNORMAL'], 
                        $testData['ISCRITICAL'], 
                        $testData['vtype'], 
                        $testData['labno'], 
                        $testData['testcode']
                    );
                    $stmt->execute();
                    $stmt->close();
                }
            } else {
                // Perform an INSERT operation
                $insertQuery = "INSERT INTO " . $table_initial . "tbtests (vtype, labno, testcode, testhead, testsubhead, testname, RESULT, 
                                pRESULT, REFVALUE, units, torder, ISNORMAL, ISCRITICAL) 
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                if ($stmt = $conn->prepare($insertQuery)) {
                    $stmt->bind_param(
                        "siisssssssiis", 
                        $testData['vtype'], 
                        $testData['labno'], 
                        $testData['testcode'], 
                        $testData['testhead'], 
                        $testData['testsubhead'], 
                        $testData['testname'], 
                        $testData['RESULT'], 
                        $testData['pRESULT'], 
                        $testData['REFVALUE'], 
                        $testData['units'], 
                        $testData['torder'], 
                        $testData['ISNORMAL'], 
                        $testData['ISCRITICAL']
                    );
                    $stmt->execute();
                    $stmt->close();
                }
            }
        }
    }

    // Send a success message back to the client
    echo json_encode(["status" => "success", "message" => "Test data processed successfully"]);
} else {
    // Send an error message if no valid JSON data is received
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
}

// Close the database connection
$conn->close();
?>
